# Sprint [NUMBER] - [SPRINT_NAME] Report
**Team:** [TEAM_NAME]  
**Scrum Master:** [SCRUM_MASTER_NAME]  
**Sprint Period:** [START_DATE] to [END_DATE]  
**Report Date:** [REPORT_DATE]

---

## Executive Summary

**Sprint Goal Achievement:** [ACHIEVED/PARTIALLY_ACHIEVED/NOT_ACHIEVED]  
**Overall Health Grade:** [EXCELLENT/GOOD/FAIR/POOR] ([HEALTH_SCORE]/100)  
**Velocity:** [COMPLETED_POINTS] points ([VELOCITY_TREND] from previous sprint)  
**Commitment Ratio:** [COMMITMENT_PERCENTAGE]% of planned work completed

### Key Highlights
- [KEY_ACHIEVEMENT_1]
- [KEY_ACHIEVEMENT_2] 
- [KEY_CHALLENGE_1]
- [KEY_CHALLENGE_2]

---

## Sprint Metrics Dashboard

### Delivery Performance
| Metric | Value | Target | Status |
|--------|-------|---------|--------|
| **Planned Points** | [PLANNED_POINTS] | - | - |
| **Completed Points** | [COMPLETED_POINTS] | [TARGET_VELOCITY] | [ON_TRACK/BELOW/ABOVE] |
| **Commitment Ratio** | [COMMITMENT_PERCENTAGE]% | 85-100% | [EXCELLENT/GOOD/NEEDS_IMPROVEMENT] |
| **Stories Completed** | [COMPLETED_STORIES]/[TOTAL_STORIES] | 80%+ | [EXCELLENT/GOOD/NEEDS_IMPROVEMENT] |
| **Carry-over Points** | [CARRY_OVER_POINTS] | <20% | [GOOD/ACCEPTABLE/CONCERNING] |

### Process Health
| Metric | Value | Target | Status |
|--------|-------|---------|--------|
| **Scope Change** | [SCOPE_CHANGE_PERCENTAGE]% | <15% | [STABLE/MODERATE/UNSTABLE] |
| **Blocker Resolution** | [AVG_RESOLUTION_DAYS] days | <3 days | [EXCELLENT/GOOD/NEEDS_IMPROVEMENT] |
| **Daily Standup Attendance** | [STANDUP_ATTENDANCE]% | >90% | [EXCELLENT/GOOD/NEEDS_IMPROVEMENT] |
| **Retrospective Participation** | [RETRO_ATTENDANCE]% | >95% | [EXCELLENT/GOOD/NEEDS_IMPROVEMENT] |

### Quality Indicators
| Metric | Value | Target | Status |
|--------|-------|---------|--------|
| **Definition of Done Adherence** | [DOD_ADHERENCE]% | 100% | [EXCELLENT/NEEDS_IMPROVEMENT] |
| **Test Coverage** | [TEST_COVERAGE]% | >80% | [EXCELLENT/GOOD/NEEDS_IMPROVEMENT] |
| **Code Review Completion** | [CODE_REVIEW_COMPLETION]% | 100% | [EXCELLENT/NEEDS_IMPROVEMENT] |
| **Technical Debt Items** | [TECH_DEBT_ADDED]/[TECH_DEBT_RESOLVED] | Net negative | [IMPROVING/STABLE/CONCERNING] |

---

## User Stories Delivered

### Completed Stories ([COMPLETED_COUNT])
| Story ID | Title | Points | Owner | Completion Date | Notes |
|----------|-------|---------|-------|----------------|-------|
| [STORY_ID_1] | [STORY_TITLE_1] | [POINTS_1] | [OWNER_1] | [DATE_1] | [NOTES_1] |
| [STORY_ID_2] | [STORY_TITLE_2] | [POINTS_2] | [OWNER_2] | [DATE_2] | [NOTES_2] |

### In Progress Stories ([IN_PROGRESS_COUNT])
| Story ID | Title | Points | Owner | Progress | Expected Completion |
|----------|-------|---------|-------|----------|-------------------|
| [STORY_ID_3] | [STORY_TITLE_3] | [POINTS_3] | [OWNER_3] | [PROGRESS_3] | [ETA_3] |

### Blocked Stories ([BLOCKED_COUNT])
| Story ID | Title | Points | Owner | Blocker | Days Blocked | Escalation Status |
|----------|-------|---------|-------|---------|-------------|------------------|
| [STORY_ID_4] | [STORY_TITLE_4] | [POINTS_4] | [OWNER_4] | [BLOCKER_4] | [DAYS_4] | [ESCALATION_4] |

---

## Blockers & Impediments

### Resolved This Sprint ([RESOLVED_BLOCKERS_COUNT])
| ID | Description | Category | Created | Resolved | Resolution Time | Impact |
|----|-------------|----------|---------|----------|----------------|---------|
| [BLOCKER_ID_1] | [DESCRIPTION_1] | [CATEGORY_1] | [CREATED_1] | [RESOLVED_1] | [TIME_1] days | [IMPACT_1] |

### Active Blockers ([ACTIVE_BLOCKERS_COUNT])
| ID | Description | Category | Age | Owner | Next Steps | Priority |
|----|-------------|----------|-----|-------|------------|----------|
| [BLOCKER_ID_2] | [DESCRIPTION_2] | [CATEGORY_2] | [AGE_2] days | [OWNER_2] | [NEXT_STEPS_2] | [PRIORITY_2] |

### Escalation Required
- [ESCALATION_ITEM_1]
- [ESCALATION_ITEM_2]

---

## Team Performance Analysis

### Velocity Trend
```
Sprint [N-2]: [VELOCITY_N2] points
Sprint [N-1]: [VELOCITY_N1] points  
Sprint [N]:   [VELOCITY_N] points
Trend: [IMPROVING/STABLE/DECLINING] ([TREND_PERCENTAGE]% change)
```

### Predictability Assessment
- **Coefficient of Variation:** [CV_PERCENTAGE]% ([HIGH/MODERATE/LOW] volatility)
- **Commitment Reliability:** [COMMITMENT_RELIABILITY_SCORE]/100
- **Forecast Confidence:** [FORECAST_CONFIDENCE]% for next sprint

### Team Health Indicators
| Dimension | Score | Grade | Trend | Action Required |
|-----------|-------|--------|-------|-----------------|
| **Commitment Reliability** | [SCORE_1]/100 | [GRADE_1] | [TREND_1] | [ACTION_1] |
| **Scope Stability** | [SCORE_2]/100 | [GRADE_2] | [TREND_2] | [ACTION_2] |
| **Blocker Resolution** | [SCORE_3]/100 | [GRADE_3] | [TREND_3] | [ACTION_3] |
| **Ceremony Engagement** | [SCORE_4]/100 | [GRADE_4] | [TREND_4] | [ACTION_4] |
| **Story Completion** | [SCORE_5]/100 | [GRADE_5] | [TREND_5] | [ACTION_5] |

---

## Retrospective Insights

### What Went Well
- [WENT_WELL_1]
- [WENT_WELL_2]
- [WENT_WELL_3]

### Areas for Improvement  
- [IMPROVE_1]
- [IMPROVE_2]
- [IMPROVE_3]

### Action Items from Retrospective
| ID | Action | Owner | Due Date | Priority | Status |
|----|--------|-------|----------|----------|--------|
| [AI_ID_1] | [ACTION_1] | [OWNER_1] | [DUE_1] | [PRIORITY_1] | [STATUS_1] |
| [AI_ID_2] | [ACTION_2] | [OWNER_2] | [DUE_2] | [PRIORITY_2] | [STATUS_2] |

### Previous Sprint Action Items Follow-up
| ID | Action | Owner | Status | Completion Notes |
|----|--------|-------|--------|------------------|
| [PREV_AI_1] | [PREV_ACTION_1] | [PREV_OWNER_1] | [PREV_STATUS_1] | [PREV_NOTES_1] |

---

## Risks & Dependencies

### High Priority Risks
| Risk | Probability | Impact | Mitigation Plan | Owner |
|------|-------------|---------|-----------------|-------|
| [RISK_1] | [PROB_1] | [IMPACT_1] | [MITIGATION_1] | [OWNER_1] |

### External Dependencies
| Dependency | Provider | Status | Expected Resolution | Contingency Plan |
|------------|----------|--------|---------------------|------------------|
| [DEP_1] | [PROVIDER_1] | [STATUS_1] | [RESOLUTION_1] | [CONTINGENCY_1] |

---

## Looking Ahead: Next Sprint

### Sprint Goals
1. [GOAL_1]
2. [GOAL_2] 
3. [GOAL_3]

### Planned Capacity
- **Team Size:** [TEAM_SIZE] members
- **Available Capacity:** [AVAILABLE_HOURS] hours ([CAPACITY_POINTS] points)
- **Planned Velocity:** [PLANNED_VELOCITY] points
- **Capacity Buffer:** [BUFFER_PERCENTAGE]% for unknowns

### Key Focus Areas
- [FOCUS_AREA_1]
- [FOCUS_AREA_2]
- [FOCUS_AREA_3]

### Dependencies to Monitor
- [MONITOR_DEP_1]
- [MONITOR_DEP_2]

---

## Recommendations

### Immediate Actions (This Sprint)
1. **[HIGH_PRIORITY_ACTION_1]** - [DESCRIPTION] (Owner: [OWNER], Due: [DATE])
2. **[HIGH_PRIORITY_ACTION_2]** - [DESCRIPTION] (Owner: [OWNER], Due: [DATE])

### Process Improvements (Next 2-3 Sprints)  
1. **[PROCESS_IMPROVEMENT_1]** - [DESCRIPTION]
2. **[PROCESS_IMPROVEMENT_2]** - [DESCRIPTION]

### Team Development Opportunities
1. **[DEVELOPMENT_1]** - [DESCRIPTION]
2. **[DEVELOPMENT_2]** - [DESCRIPTION]

---

## Appendix

### Sprint Burndown Chart
[BURNDOWN_CHART_REFERENCE]

### Detailed Metrics
[DETAILED_METRICS_REFERENCE]

### Team Feedback
[TEAM_FEEDBACK_SUMMARY]

---

**Report prepared by:** [SCRUM_MASTER_NAME]  
**Next review date:** [NEXT_REVIEW_DATE]  
**Distribution:** Product Owner, Development Team, Stakeholders

---
*This report is generated using standardized sprint health metrics and retrospective analysis. For questions or deeper analysis, please contact the Scrum Master.*