# Global Regulatory Pathways

International regulatory requirements for medical devices beyond FDA and EU MDR markets.

---

## Table of Contents

- [Canada (Health Canada)](#canada-health-canada)
- [Japan (PMDA)](#japan-pmda)
- [China (NMPA)](#china-nmpa)
- [Australia (TGA)](#australia-tga)
- [Brazil (ANVISA)](#brazil-anvisa)
- [Market Entry Strategy](#market-entry-strategy)

---

## Canada (Health Canada)

### Device Classification

| Class | Risk Level | Examples | Review Type |
|-------|------------|----------|-------------|
| I | Lowest | Tongue depressors, bandages | Establishment license only |
| II | Low-moderate | Contact lenses, pregnancy tests | Declaration of conformity |
| III | Moderate-high | Orthopedic implants, ventilators | Pre-market review |
| IV | Highest | Pacemakers, HIV tests | In-depth pre-market review |

### Medical Device License (MDL) Requirements

**Class II-IV Devices:**
1. Device license application via MDALL (Medical Devices Active License Listing)
2. Quality management system documentation (ISO 13485)
3. Device safety and effectiveness evidence
4. Canadian labeling requirements (French/English bilingual)
5. Canadian Medical Device Single Audit Program (CMDCAS) certificate

**Review Timelines:**
| Class | Standard Review | Priority Review |
|-------|-----------------|-----------------|
| II | 15 days | N/A |
| III | 60 days | 30 days |
| IV | 75 days | 45 days |

### Key Requirements

| Requirement | Details |
|-------------|---------|
| QMS Audit | MDSAP or ISO 13485 audit by recognized body |
| UDI | Canadian UDI-DI required in MDALL |
| Labeling | Bilingual (English/French) mandatory |
| Incident Reporting | Mandatory problem reporting within 10-30 days |
| Post-Market | Annual license maintenance |

---

## Japan (PMDA)

### Device Classification (Pharmaceutical and Medical Device Act)

| Class | Japanese Term | Examples | Regulatory Path |
|-------|---------------|----------|-----------------|
| I | General | Scalpels, X-ray film | Self-certification |
| II | Controlled | MRI, ultrasound | Third-party certification |
| III | Specially Controlled | Pacemaker leads, dialyzers | PMDA Shonin approval |
| IV | Specially Controlled | Pacemakers, artificial hearts | PMDA Shonin approval |

### Shonin Approval Process

**Pre-Application:**
1. Classification consultation with PMDA
2. Pre-submission meeting (recommended for Class III/IV)
3. Japanese clinical data requirements assessment
4. Marketing Authorization Holder (MAH) designation

**Application Requirements:**
- Technical documentation per MHLW format
- Japanese clinical data (bridging study may be required)
- QMS compliance certificate (ISO 13485)
- GCP compliance for clinical studies
- Japanese labeling and IFU

**Review Timelines:**
| Application Type | Standard | Priority |
|------------------|----------|----------|
| New Shonin | 12 months | 6 months |
| Partial Change | 6-9 months | 3-4 months |

### Special Considerations

| Factor | Requirement |
|--------|-------------|
| Clinical Data | Japanese patient data often required |
| MAH | Requires Japanese MAH or Designated MAH (D-MAH) |
| QMS | MHLW Minister certification or ISO 13485 |
| Language | All documents in Japanese |
| Foreign Manufacturer | Accreditation required |

---

## China (NMPA)

### Device Classification

| Class | Risk Level | Examples | Regulatory Path |
|-------|------------|----------|-----------------|
| I | Low | Surgical instruments | Provincial filing |
| II | Moderate | Diagnostic ultrasound, ECG | Provincial registration |
| III | High | Pacemakers, implants | NMPA registration |

### Registration Requirements

**Class II/III Registration:**
1. Clinical evaluation or trial (China-specific requirements)
2. Product technical requirements document
3. Type testing by NMPA-designated lab
4. Quality management system (ISO 13485 + Chinese requirements)
5. Chinese agent appointment (CSRC holder)

**Review Process:**
| Stage | Class II | Class III |
|-------|----------|-----------|
| Technical Review | 60 working days | 90 working days |
| Administrative Review | 20 working days | 20 working days |
| Registration Certificate | 5 years validity | 5 years validity |

### Key Requirements

| Requirement | Details |
|-------------|---------|
| Clinical Trial | Required for most Class III; China-specific data |
| Testing | NMPA-designated testing laboratory |
| Agent | Chinese Service Representative Certificate (CSRC) holder |
| Labeling | Simplified Chinese mandatory |
| QMS | Chinese GMP compliance in addition to ISO 13485 |

### China Clinical Trial Requirements

| Device Type | Clinical Requirement |
|-------------|---------------------|
| First-of-kind | Full clinical trial in China |
| Well-established | Literature + clinical evaluation |
| Equivalent device | Comparative analysis + limited data |

---

## Australia (TGA)

### Device Classification (TGO 41)

| Class | Risk Level | Examples | Conformity Route |
|-------|------------|----------|------------------|
| I | Lowest | Surgical retractors | Manufacturer declaration |
| I (measuring) | Low | Clinical thermometers | EU/MDSAP certificate |
| I (sterile) | Low | Sterile gloves | EU/MDSAP certificate |
| IIa | Low-moderate | Hearing aids, ultrasound | EU/MDSAP certificate |
| IIb | Moderate-high | Ventilators, X-ray | EU/MDSAP certificate |
| III | High | Pacemakers, implants | EU/MDSAP certificate |
| AIMD | Active implants | Cochlear implants | EU/MDSAP certificate |

### Australian Register of Therapeutic Goods (ARTG)

**Registration Requirements:**
1. Australian sponsor (manufacturer or importer)
2. Conformity assessment evidence (EU certificate or MDSAP)
3. Australian labeling compliance
4. Adverse event reporting system
5. ARTG application and fees

**Pathways:**
| Pathway | Applicable Devices | Documentation |
|---------|-------------------|---------------|
| Conformity Assessment | All classes | EU/MDSAP certificates accepted |
| Comparable Overseas Regulator | Established devices | Recognition of FDA/EU approval |
| TGA Audit | No overseas certificate | TGA conducts assessment |

### Key Requirements

| Requirement | Details |
|-------------|---------|
| Sponsor | Australian-based sponsor mandatory |
| Conformity | EU MDR/IVDR or MDSAP certificate |
| Labeling | English, Australian-specific requirements |
| Incident Reporting | Mandatory within 48 hours (serious) |
| Annual Charges | Based on ARTG listing |

---

## Brazil (ANVISA)

### Device Classification (RDC 185/2001)

| Class | Risk Level | Examples | Registration |
|-------|------------|----------|--------------|
| I | Low | Tongue depressors | Notification (cadastro) |
| II | Low-moderate | Wheelchairs, syringes | Notification (cadastro) |
| III | Moderate-high | Hemodialysis, implants | Registration (registro) |
| IV | High | Pacemakers, stents | Registration (registro) |

### Registration Process

**Cadastro (Class I/II):**
- Brazilian Registration Holder (BRH) application
- Technical documentation
- Good Manufacturing Practice (GMP) certificate
- Free sale certificate from country of origin

**Registro (Class III/IV):**
- Full technical dossier submission
- ANVISA GMP inspection (if not MDSAP)
- Clinical data requirements
- Brazilian labeling and IFU
- Registration validity: 5 years (Class III) or 10 years (Class IV)

### Key Requirements

| Requirement | Details |
|-------------|---------|
| BRH | Brazilian Registration Holder mandatory |
| GMP | ANVISA inspection or MDSAP certificate |
| INMETRO | Certification for specific device categories |
| Language | Portuguese labeling and IFU |
| Clinical | Brazilian clinical data may be required |

**Review Timelines:**
| Type | Standard | Priority |
|------|----------|----------|
| Cadastro | 30-60 days | N/A |
| Registro | 180-365 days | 90-180 days |

---

## Market Entry Strategy

### Prioritization Framework

| Factor | Weight | Considerations |
|--------|--------|----------------|
| Market Size | 25% | Revenue potential, growth rate |
| Regulatory Complexity | 25% | Timeline, cost, local requirements |
| Competitive Landscape | 20% | Existing players, differentiation |
| Reimbursement | 20% | Payer coverage, pricing |
| Strategic Value | 10% | Reference market, regional hub |

### Recommended Entry Sequence

**Phase 1: Priority Markets (Year 1)**
- United States (FDA)
- European Union (MDR)
- Leverage for downstream approvals

**Phase 2: Recognition Markets (Year 1-2)**
- Australia (TGA) - accepts EU/MDSAP
- Canada (Health Canada) - MDSAP pathway
- Faster approval using existing evidence

**Phase 3: Major Markets (Year 2-3)**
- Japan (PMDA) - may require local clinical
- China (NMPA) - local testing and clinical

**Phase 4: Emerging Markets (Year 3+)**
- Brazil (ANVISA)
- Other Latin America
- Middle East, Southeast Asia

### Documentation Efficiency

| Document Type | Create Once | Localize Per Market |
|---------------|-------------|---------------------|
| Technical file | Core technical documentation | Specific format requirements |
| Clinical data | Global clinical study | Local bridging studies |
| QMS certificate | ISO 13485 / MDSAP | Market-specific audits |
| Labeling | Master label content | Language, local requirements |

### Common Pitfalls

| Pitfall | Impact | Prevention |
|---------|--------|------------|
| Underestimating local clinical requirements | 12-24 month delay | Early regulatory intelligence |
| Inadequate in-country representation | Registration rejection | Qualified local partner |
| Language/labeling non-compliance | Market rejection | Professional translation review |
| Ignoring post-market requirements | License suspension | Establish vigilance system |
| Sequential vs. parallel submissions | Extended timeline | Plan parallel submissions where possible |
