# ISO 13485 Audit Guide

Clause-by-clause audit methodology with sample questions and common findings.

---

## Table of Contents

- [Audit Approach](#audit-approach)
- [Clause 4: Quality Management System](#clause-4-quality-management-system)
- [Clause 5: Management Responsibility](#clause-5-management-responsibility)
- [Clause 6: Resource Management](#clause-6-resource-management)
- [Clause 7: Product Realization](#clause-7-product-realization)
- [Clause 8: Measurement and Improvement](#clause-8-measurement-and-improvement)
- [Common Nonconformities](#common-nonconformities)

---

## Audit Approach

### Risk-Based Audit Planning

Prioritize audit focus based on:

| Risk Level | Audit Frequency | Scope Depth |
|------------|-----------------|-------------|
| High | Quarterly | Full clause review |
| Medium | Semi-annual | Targeted review |
| Low | Annual | Sampling-based |

### Evidence Collection Methods

| Method | Best For | Examples |
|--------|----------|----------|
| Document review | Procedures, records | SOPs, DHF, batch records |
| Interview | Process understanding | Operators, supervisors |
| Observation | Actual practice | Production, calibration |
| Tracing | Process flow | Order to delivery |

---

## Clause 4: Quality Management System

### 4.1 General Requirements

**Audit Questions:**
- Show me documentation of your QMS scope and exclusions
- How do you identify processes needed for the QMS?
- Show me evidence of outsourced process control

**Evidence to Review:**
- [ ] Quality Manual or QMS description
- [ ] Process interaction diagram
- [ ] Outsourced process agreements

**Common Findings:**
- Scope exclusions not justified
- Outsourced processes not controlled
- Process interactions not defined

### 4.2 Documentation Requirements

**4.2.1-4.2.2 Quality Manual and Documents**

**Audit Questions:**
- Where is your documented quality policy?
- Show me the procedure for document control
- How do you ensure documents are current at point of use?

**Evidence to Review:**
- [ ] Quality Manual
- [ ] Document master list
- [ ] Sample of controlled documents

**4.2.4 Control of Records**

**Audit Questions:**
- What is your record retention policy?
- Show me the procedure for record storage and protection
- How do you ensure record legibility and retrievability?

**Evidence to Review:**
- [ ] Record control procedure
- [ ] Retention schedule
- [ ] Sample record retrieval test

**Common Findings:**
- Obsolete documents in use
- Records not legible or retrievable
- Retention periods not defined for all record types

---

## Clause 5: Management Responsibility

### 5.1-5.2 Management Commitment and Customer Focus

**Audit Questions:**
- How does top management demonstrate commitment to QMS?
- Show me evidence of customer requirement determination
- How are regulatory requirements communicated?

**Evidence to Review:**
- [ ] Quality policy communication
- [ ] Management review minutes
- [ ] Customer feedback records

### 5.4 Planning

**Audit Questions:**
- Where are your quality objectives documented?
- Show me the plan for achieving quality objectives
- How do you maintain QMS integrity during changes?

**Evidence to Review:**
- [ ] Quality objectives (measurable, time-bound)
- [ ] Quality planning documentation
- [ ] Change management records

### 5.5 Responsibility and Authority

**Audit Questions:**
- Where are responsibilities and authorities defined?
- Who is the management representative?
- How is QMS performance communicated to top management?

**Evidence to Review:**
- [ ] Organization chart
- [ ] Job descriptions with QMS responsibilities
- [ ] Management representative appointment

### 5.6 Management Review

**Audit Questions:**
- Show me management review records from last 12 months
- What inputs are included in management review?
- What decisions and actions resulted?

**Required Review Inputs:**
- [ ] Audit results
- [ ] Customer feedback (including complaints)
- [ ] Process performance and product conformity
- [ ] CAPA status
- [ ] Changes affecting QMS
- [ ] Recommendations for improvement
- [ ] New/revised regulatory requirements

**Common Findings:**
- Management review not conducted at planned intervals
- Required inputs missing
- Action items not tracked to completion

---

## Clause 6: Resource Management

### 6.1-6.2 Human Resources

**Audit Questions:**
- How do you determine competency requirements?
- Show me training records for personnel affecting quality
- How do you evaluate training effectiveness?

**Evidence to Review:**
- [ ] Competency requirements by role
- [ ] Training records
- [ ] Effectiveness evaluations

### 6.3-6.4 Infrastructure and Work Environment

**Audit Questions:**
- How do you determine infrastructure requirements?
- Show me maintenance records for critical equipment
- How is work environment controlled for product conformity?

**Evidence to Review:**
- [ ] Equipment list with maintenance schedules
- [ ] Environmental monitoring records
- [ ] Contamination control procedures (if applicable)

**Common Findings:**
- Training effectiveness not evaluated
- Preventive maintenance not performed on schedule
- Environmental conditions not monitored

---

## Clause 7: Product Realization

### 7.1 Planning of Product Realization

**Audit Questions:**
- Show me the quality plan for a recent product
- How do you determine verification and validation activities?
- What records are required to demonstrate conformity?

**Evidence to Review:**
- [ ] Quality plan or project plan
- [ ] Risk management integration
- [ ] Required records defined

### 7.2 Customer-Related Processes

**Audit Questions:**
- How do you determine customer requirements?
- Show me the contract review process
- How do you handle customer communications?

**Evidence to Review:**
- [ ] Contract/order review records
- [ ] Customer requirement documentation
- [ ] Communication records

### 7.3 Design and Development

**Audit Questions (per phase):**

| Phase | Key Questions |
|-------|---------------|
| Planning | Show me design plan with stages, reviews, responsibilities |
| Inputs | How are regulatory requirements identified? |
| Outputs | Show me design outputs addressing inputs |
| Review | Who participated in design reviews? |
| Verification | Show me verification activities and results |
| Validation | Show me validation under actual use conditions |
| Transfer | How was design transferred to production? |
| Changes | Show me design change control records |

**Evidence to Review:**
- [ ] Design History File (DHF)
- [ ] Design review records with participants
- [ ] Verification/validation protocols and reports
- [ ] Design change requests

### 7.4 Purchasing

**Audit Questions:**
- How do you evaluate and select suppliers?
- Show me approved supplier list with evaluation criteria
- How do you verify purchased product?

**Evidence to Review:**
- [ ] Supplier evaluation procedure
- [ ] Approved supplier list
- [ ] Incoming inspection records
- [ ] Supplier audit records

### 7.5 Production and Service Provision

**Audit Questions:**
- Show me work instructions for production
- How are special processes validated?
- Show me traceability records for a product lot

**Evidence to Review:**
- [ ] Production work instructions
- [ ] Process validation records
- [ ] Device history records (DHR)
- [ ] Traceability records

### 7.6 Control of Monitoring and Measuring Equipment

**Audit Questions:**
- Show me calibration records for measuring equipment
- How do you handle out-of-tolerance conditions?
- How is software used for monitoring validated?

**Evidence to Review:**
- [ ] Equipment calibration records
- [ ] Calibration procedure
- [ ] Out-of-tolerance investigation records

**Common Findings:**
- Design inputs not completely addressed in outputs
- Supplier evaluations not performed or documented
- Process validation not maintained after changes
- Calibration overdue

---

## Clause 8: Measurement and Improvement

### 8.2.1 Feedback

**Audit Questions:**
- How do you collect customer feedback?
- Show me complaint handling records
- How is feedback data used for improvement?

**Evidence to Review:**
- [ ] Complaint procedure
- [ ] Complaint log with trending
- [ ] Feedback to design/production

### 8.2.2 Internal Audit

**Audit Questions:**
- Show me the internal audit schedule
- How do you ensure auditor independence?
- Show me audit records and follow-up actions

**Evidence to Review:**
- [ ] Audit program/schedule
- [ ] Auditor qualification records
- [ ] Audit reports and findings
- [ ] CAPA records from audits

### 8.2.3-8.2.4 Monitoring and Measurement

**Audit Questions:**
- How do you monitor process performance?
- Show me product acceptance records
- What happens when acceptance criteria not met?

**Evidence to Review:**
- [ ] Process monitoring data
- [ ] Inspection records
- [ ] Nonconforming product records

### 8.3 Control of Nonconforming Product

**Audit Questions:**
- Show me the procedure for nonconforming product
- How do you prevent unintended use of nonconforming product?
- Who authorizes concessions/deviations?

**Evidence to Review:**
- [ ] NC product procedure
- [ ] NC product records
- [ ] Concession authorizations

### 8.4 Analysis of Data

**Audit Questions:**
- What data do you analyze for QMS effectiveness?
- Show me trend analysis for complaints, NC, CAPA
- How does data drive improvement?

**Evidence to Review:**
- [ ] Data analysis reports
- [ ] Trend charts
- [ ] Management review inputs

### 8.5 CAPA

**Audit Questions:**
- Show me the CAPA procedure
- How do you determine root cause?
- Show me CAPA effectiveness verification

**Evidence to Review:**
- [ ] CAPA procedure
- [ ] Open/closed CAPA log
- [ ] Root cause analysis records
- [ ] Effectiveness verification records

**Common Findings:**
- Complaint trending not performed
- CAPA not initiated for recurring issues
- Root cause analysis superficial
- Effectiveness verification not documented

---

## Common Nonconformities

### Top 10 ISO 13485 Audit Findings

| Rank | Clause | Finding |
|------|--------|---------|
| 1 | 7.3 | Design inputs not traceable to outputs |
| 2 | 8.5 | CAPA effectiveness not verified |
| 3 | 4.2.4 | Records not retrievable or legible |
| 4 | 7.4 | Supplier evaluation not documented |
| 5 | 6.2 | Training effectiveness not evaluated |
| 6 | 7.5.2 | Process validation not maintained |
| 7 | 8.2.2 | Internal audits not covering all clauses |
| 8 | 5.6 | Management review inputs incomplete |
| 9 | 7.6 | Calibration records incomplete |
| 10 | 8.3 | NC product control inadequate |

### Finding Severity Classification

| Severity | Definition | Response Required |
|----------|------------|-------------------|
| Major | Systematic failure, absence of element | CAPA within 30 days |
| Minor | Isolated lapse, partial implementation | Correction within 60 days |
| Observation | Improvement opportunity | Optional action |
