# International Market Playbooks

Market-specific tactics for EU, US, and Canada expansion.

---

## Table of Contents

- [EU Market Entry](#eu-market-entry)
- [US Market Entry](#us-market-entry)
- [Canada Market Entry](#canada-market-entry)
- [Budget Allocation by Region](#budget-allocation-by-region)
- [Localization Checklist](#localization-checklist)

---

## EU Market Entry

### Compliance Requirements

| Requirement | Implementation |
|-------------|----------------|
| GDPR consent | Double opt-in for email |
| Cookie consent | Explicit consent banner |
| Data storage | EU data center option |
| Privacy policy | EU-specific language |

**HubSpot Configuration:**
- Enable double opt-in in Forms settings
- Configure consent tracking properties
- Set up GDPR deletion workflows

### Localization Priority

| Language | Market Priority | Revenue Potential |
|----------|-----------------|-------------------|
| German (DE) | High | Largest EU economy |
| French (FR) | High | Second largest EU |
| Spanish (ES) | Medium | Growing tech sector |
| Dutch (NL) | Medium | English proficiency |
| Italian (IT) | Lower | Later expansion |

### Channel Mix (EU)

| Channel | Budget % | Rationale |
|---------|----------|-----------|
| LinkedIn | 40% | Primary B2B channel |
| Google Ads | 25% | High intent capture |
| SEO | 20% | Long-term investment |
| Partnerships | 15% | Local credibility |

### EU Messaging Adjustments

- More formal tone than US
- Focus on data security and compliance
- Emphasize local customer references
- Include EU headquarters or presence
- Display prices in EUR

**Validation:** Test landing pages with EU VPN. Verify consent flows work correctly.

---

## US Market Entry

### Market Characteristics

| Aspect | US Approach |
|--------|-------------|
| Messaging | Direct, ROI-focused |
| Tone | Less formal than EU |
| Sales cycle | Faster decision-making |
| Proof points | Dollar impact, not features |

### Channel Mix (US)

| Channel | Budget % | Rationale |
|---------|----------|-----------|
| Google Ads | 35% | High commercial intent |
| LinkedIn | 30% | B2B targeting |
| SEO | 20% | Competitive necessity |
| Partnerships | 15% | Industry associations |

### Partner Ecosystem

| Partner Type | Examples |
|--------------|----------|
| Review sites | G2, Capterra, TrustRadius |
| Industry associations | SaaStr, ProductLed |
| Integration partners | Salesforce, HubSpot |
| Channel partners | VARs, consultants |

### Content Adjustments

- Case studies with $ impact metrics
- Faster, more aggressive CTAs
- Video testimonials with customers
- Comparison pages (vs. competitors)

**Validation:** US-based speed test. Payment processing in USD functional.

---

## Canada Market Entry

### Market Characteristics

| Aspect | Canada Approach |
|--------|-----------------|
| Language | English + French (Quebec) |
| Regulation | PIPEDA compliance |
| Messaging | Mix of US and EU styles |
| Pricing | CAD display preferred |

### Regional Considerations

| Region | Language | Focus |
|--------|----------|-------|
| Ontario | English | Tech hub, Toronto |
| British Columbia | English | Vancouver tech scene |
| Quebec | French | Requires localization |
| Alberta | English | Energy sector |

### Channel Mix (Canada)

| Channel | Budget % | Rationale |
|---------|----------|-----------|
| Google Ads | 35% | Primary acquisition |
| LinkedIn | 30% | Professional targeting |
| SEO | 20% | Local content |
| Partnerships | 15% | Local associations |

**Validation:** French Quebec landing page tested. CAD pricing displays correctly.

---

## Budget Allocation by Region

### Series A Recommended Split

| Region | Budget % | Expected CAC |
|--------|----------|--------------|
| US | 50% | $150-300 |
| EU | 35% | $200-400 |
| Canada | 15% | $175-350 |

### Channel by Region Matrix

| Channel | US | EU | Canada |
|---------|----|----|--------|
| LinkedIn | 30% | 40% | 30% |
| Google | 35% | 25% | 35% |
| SEO | 20% | 20% | 20% |
| Partners | 15% | 15% | 15% |

### Scaling Criteria

Expand regional budget when:
- CAC < 80% of target for 4 consecutive weeks
- MQL→SQL rate > regional benchmark
- Sales team has regional capacity

---

## Localization Checklist

### Website Localization

- [ ] Translate navigation and UI elements
- [ ] Localize pricing (currency, formatting)
- [ ] Adapt case studies to regional references
- [ ] Update screenshots with localized UI
- [ ] Configure hreflang tags correctly
- [ ] Submit to regional search consoles

### Content Localization

- [ ] Translate (don't just localize) key pages
- [ ] Adapt idioms and cultural references
- [ ] Update date formats (DD/MM/YYYY vs MM/DD/YYYY)
- [ ] Adjust number formatting (1,000 vs 1.000)
- [ ] Use regional spelling (optimise vs optimize)

### Campaign Localization

- [ ] Translate ad copy (not just translate, adapt)
- [ ] Create regional landing pages
- [ ] Set up regional tracking parameters
- [ ] Configure regional lead routing
- [ ] Align with regional sales hours

### Legal Localization

- [ ] GDPR compliance (EU)
- [ ] PIPEDA compliance (Canada)
- [ ] Cookie consent mechanisms
- [ ] Privacy policy translations
- [ ] Terms of service updates

**Validation:** Native speaker review of all localized content before launch.
