# Vulnerability Assessment Guide

A comprehensive guide to assessing, prioritizing, and managing security vulnerabilities in software dependencies.

## Overview

Dependency vulnerabilities represent one of the most significant attack vectors in modern software systems. This guide provides a structured approach to vulnerability assessment, risk scoring, and remediation planning.

## Vulnerability Classification System

### Severity Levels (CVSS 3.1)

#### Critical (9.0 - 10.0)
- **Impact**: Complete system compromise possible
- **Examples**: Remote code execution, privilege escalation to admin
- **Response Time**: Immediate (within 24 hours)
- **Business Risk**: System shutdown, data breach, regulatory violations

#### High (7.0 - 8.9)
- **Impact**: Significant security impact
- **Examples**: SQL injection, authentication bypass, sensitive data exposure
- **Response Time**: 7 days maximum
- **Business Risk**: Data compromise, service disruption

#### Medium (4.0 - 6.9)
- **Impact**: Moderate security impact
- **Examples**: Cross-site scripting (XSS), information disclosure
- **Response Time**: 30 days
- **Business Risk**: Limited data exposure, minor service impact

#### Low (0.1 - 3.9)
- **Impact**: Limited security impact
- **Examples**: Denial of service (limited), minor information leakage
- **Response Time**: Next planned release cycle
- **Business Risk**: Minimal impact on operations

## Vulnerability Types and Patterns

### Code Injection Vulnerabilities

#### SQL Injection
- **CWE-89**: Improper neutralization of SQL commands
- **Common in**: Database interaction libraries, ORM frameworks
- **Detection**: Parameter handling analysis, query construction review
- **Mitigation**: Parameterized queries, input validation, least privilege DB access

#### Command Injection
- **CWE-78**: OS command injection
- **Common in**: System utilities, file processing libraries
- **Detection**: System call analysis, user input handling
- **Mitigation**: Input sanitization, avoid system calls, sandboxing

#### Code Injection
- **CWE-94**: Code injection
- **Common in**: Template engines, dynamic code evaluation
- **Detection**: eval() usage, dynamic code generation
- **Mitigation**: Avoid dynamic code execution, input validation, sandboxing

### Authentication and Authorization

#### Authentication Bypass
- **CWE-287**: Improper authentication
- **Common in**: Authentication libraries, session management
- **Detection**: Authentication flow analysis, session handling review
- **Mitigation**: Multi-factor authentication, secure session management

#### Privilege Escalation
- **CWE-269**: Improper privilege management
- **Common in**: Authorization frameworks, access control libraries
- **Detection**: Permission checking analysis, role validation
- **Mitigation**: Principle of least privilege, proper access controls

### Data Exposure

#### Sensitive Data Exposure
- **CWE-200**: Information exposure
- **Common in**: Logging libraries, error handling, API responses
- **Detection**: Log output analysis, error message review
- **Mitigation**: Data classification, sanitized logging, proper error handling

#### Cryptographic Failures
- **CWE-327**: Broken cryptography
- **Common in**: Cryptographic libraries, hash functions
- **Detection**: Algorithm analysis, key management review
- **Mitigation**: Modern cryptographic standards, proper key management

### Input Validation Issues

#### Cross-Site Scripting (XSS)
- **CWE-79**: Improper neutralization of input
- **Common in**: Web frameworks, template engines
- **Detection**: Input handling analysis, output encoding review
- **Mitigation**: Input validation, output encoding, Content Security Policy

#### Deserialization Vulnerabilities
- **CWE-502**: Deserialization of untrusted data
- **Common in**: Serialization libraries, data processing
- **Detection**: Deserialization usage analysis
- **Mitigation**: Avoid untrusted deserialization, input validation

## Risk Assessment Framework

### CVSS Scoring Components

#### Base Metrics
1. **Attack Vector (AV)**
   - Network (N): 0.85
   - Adjacent (A): 0.62
   - Local (L): 0.55
   - Physical (P): 0.2

2. **Attack Complexity (AC)**
   - Low (L): 0.77
   - High (H): 0.44

3. **Privileges Required (PR)**
   - None (N): 0.85
   - Low (L): 0.62/0.68
   - High (H): 0.27/0.50

4. **User Interaction (UI)**
   - None (N): 0.85
   - Required (R): 0.62

5. **Impact Metrics (C/I/A)**
   - High (H): 0.56
   - Low (L): 0.22
   - None (N): 0

#### Temporal Metrics
- **Exploit Code Maturity**: Proof of concept availability
- **Remediation Level**: Official fix availability
- **Report Confidence**: Vulnerability confirmation level

#### Environmental Metrics
- **Confidentiality/Integrity/Availability Requirements**: Business impact
- **Modified Base Metrics**: Environment-specific adjustments

### Custom Risk Factors

#### Business Context
1. **Data Sensitivity**
   - Public data: Low risk multiplier (1.0x)
   - Internal data: Medium risk multiplier (1.2x)
   - Customer data: High risk multiplier (1.5x)
   - Regulated data: Critical risk multiplier (2.0x)

2. **System Criticality**
   - Development: Low impact (1.0x)
   - Staging: Medium impact (1.3x)
   - Production: High impact (1.8x)
   - Core infrastructure: Critical impact (2.5x)

3. **Exposure Level**
   - Internal systems: Base risk
   - Partner access: +1 risk level
   - Public internet: +2 risk levels
   - High-value target: +3 risk levels

#### Technical Factors

1. **Dependency Type**
   - Direct dependencies: Higher priority
   - Transitive dependencies: Lower priority (unless critical path)
   - Development dependencies: Lowest priority

2. **Usage Pattern**
   - Core functionality: Highest priority
   - Optional features: Medium priority
   - Unused code paths: Lowest priority

3. **Fix Availability**
   - Official patch available: Standard timeline
   - Workaround available: Extended timeline acceptable
   - No fix available: Risk acceptance or replacement needed

## Vulnerability Discovery and Monitoring

### Automated Scanning

#### Dependency Scanners
- **npm audit**: Node.js ecosystem
- **pip-audit**: Python ecosystem
- **bundler-audit**: Ruby ecosystem
- **OWASP Dependency Check**: Multi-language support

#### Continuous Monitoring
```bash
# Example CI/CD integration
name: Security Scan
on: [push, pull_request, schedule]
jobs:
  security-scan:
    runs-on: ubuntu-latest
    steps:
      - uses: actions/checkout@v2
      - name: Run dependency audit
        run: |
          npm audit --audit-level high
          python -m pip_audit
          bundle audit
```

#### Commercial Tools
- **Snyk**: Developer-first security platform
- **WhiteSource**: Enterprise dependency management
- **Veracode**: Application security platform
- **Checkmarx**: Static application security testing

### Manual Assessment

#### Code Review Checklist
1. **Input Validation**
   - [ ] All user inputs validated
   - [ ] Proper sanitization applied
   - [ ] Length and format restrictions

2. **Authentication/Authorization**
   - [ ] Proper authentication checks
   - [ ] Authorization at every access point
   - [ ] Session management secure

3. **Data Handling**
   - [ ] Sensitive data protected
   - [ ] Encryption properly implemented
   - [ ] Secure data transmission

4. **Error Handling**
   - [ ] No sensitive info in error messages
   - [ ] Proper logging without data leaks
   - [ ] Graceful error handling

## Prioritization Framework

### Priority Matrix

| Severity | Exploitability | Business Impact | Priority Level |
|----------|---------------|-----------------|---------------|
| Critical | High | High | P0 (Immediate) |
| Critical | High | Medium | P0 (Immediate) |
| Critical | Medium | High | P1 (24 hours) |
| High | High | High | P1 (24 hours) |
| High | High | Medium | P2 (1 week) |
| High | Medium | High | P2 (1 week) |
| Medium | High | High | P2 (1 week) |
| All Others | - | - | P3 (30 days) |

### Prioritization Factors

#### Technical Factors (40% weight)
1. **CVSS Base Score** (15%)
2. **Exploit Availability** (10%)
3. **Fix Complexity** (8%)
4. **Dependency Criticality** (7%)

#### Business Factors (35% weight)
1. **Data Impact** (15%)
2. **System Criticality** (10%)
3. **Regulatory Requirements** (5%)
4. **Customer Impact** (5%)

#### Operational Factors (25% weight)
1. **Attack Surface** (10%)
2. **Monitoring Coverage** (8%)
3. **Incident Response Capability** (7%)

### Scoring Formula
```
Priority Score = (Technical Score × 0.4) + (Business Score × 0.35) + (Operational Score × 0.25)

Where each component is scored 1-10:
- 9-10: Critical priority
- 7-8: High priority
- 5-6: Medium priority
- 3-4: Low priority
- 1-2: Informational
```

## Remediation Strategies

### Immediate Actions (P0/P1)

#### Hot Fixes
1. **Version Upgrade**
   - Update to patched version
   - Test critical functionality
   - Deploy with rollback plan

2. **Configuration Changes**
   - Disable vulnerable features
   - Implement additional access controls
   - Add monitoring/alerting

3. **Workarounds**
   - Input validation layers
   - Network-level protections
   - Application-level mitigations

#### Emergency Response Process
```
1. Vulnerability Confirmed
   ↓
2. Impact Assessment (2 hours)
   ↓
3. Mitigation Strategy (4 hours)
   ↓
4. Implementation & Testing (12 hours)
   ↓
5. Deployment (2 hours)
   ↓
6. Monitoring & Validation (ongoing)
```

### Planned Remediation (P2/P3)

#### Standard Update Process
1. **Assessment Phase**
   - Detailed impact analysis
   - Testing requirements
   - Rollback procedures

2. **Planning Phase**
   - Update scheduling
   - Resource allocation
   - Communication plan

3. **Implementation Phase**
   - Development environment testing
   - Staging environment validation
   - Production deployment

4. **Validation Phase**
   - Functionality verification
   - Security testing
   - Performance monitoring

### Alternative Approaches

#### Dependency Replacement
- **When to Consider**: No fix available, persistent vulnerabilities
- **Process**: Impact analysis → Alternative evaluation → Migration planning
- **Risks**: API changes, feature differences, stability concerns

#### Accept Risk (Last Resort)
- **Criteria**: Very low probability, minimal impact, no feasible fix
- **Requirements**: Executive approval, documented risk acceptance, monitoring
- **Conditions**: Regular re-assessment, alternative solution tracking

## Remediation Tracking

### Metrics and KPIs

#### Vulnerability Metrics
- **Mean Time to Detection (MTTD)**: Average time from publication to discovery
- **Mean Time to Patch (MTTP)**: Average time from discovery to fix deployment
- **Vulnerability Density**: Vulnerabilities per 1000 dependencies
- **Fix Rate**: Percentage of vulnerabilities fixed within SLA

#### Trend Analysis
- **Monthly vulnerability counts by severity**
- **Average age of unpatched vulnerabilities**
- **Remediation timeline trends**
- **False positive rates**

#### Reporting Dashboard
```
Security Dashboard Components:
├── Current Vulnerability Status
│   ├── Critical: 2 (SLA: 24h)
│   ├── High: 5 (SLA: 7d)
│   └── Medium: 12 (SLA: 30d)
├── Trend Analysis
│   ├── New vulnerabilities (last 30 days)
│   ├── Fixed vulnerabilities (last 30 days)
│   └── Average resolution time
└── Risk Assessment
    ├── Overall risk score
    ├── Top vulnerable components
    └── Compliance status
```

## Documentation Requirements

### Vulnerability Records
Each vulnerability should be documented with:
- **CVE/Advisory ID**: Official vulnerability identifier
- **Discovery Date**: When vulnerability was identified
- **CVSS Score**: Base and environmental scores
- **Affected Systems**: Components and versions impacted
- **Business Impact**: Risk assessment and criticality
- **Remediation Plan**: Planned fix approach and timeline
- **Resolution Date**: When fix was implemented and verified

### Risk Acceptance Documentation
For accepted risks, document:
- **Risk Description**: Detailed vulnerability explanation
- **Impact Analysis**: Potential business and technical impact
- **Mitigation Measures**: Compensating controls implemented
- **Acceptance Rationale**: Why risk is being accepted
- **Review Schedule**: When risk will be reassessed
- **Approver**: Who authorized the risk acceptance

## Integration with Development Workflow

### Shift-Left Security

#### Development Phase
- **IDE Integration**: Real-time vulnerability detection
- **Pre-commit Hooks**: Automated security checks
- **Code Review**: Security-focused review criteria

#### CI/CD Integration
- **Build Stage**: Dependency vulnerability scanning
- **Test Stage**: Security test automation
- **Deploy Stage**: Final security validation

#### Production Monitoring
- **Runtime Protection**: Web application firewalls, runtime security
- **Continuous Scanning**: Regular dependency updates check
- **Incident Response**: Automated vulnerability alert handling

### Security Gates
```yaml
security_gates:
  development:
    - dependency_scan: true
    - secret_detection: true
    - code_quality: true
  
  staging:
    - penetration_test: true
    - compliance_check: true
    - performance_test: true
  
  production:
    - final_security_scan: true
    - change_approval: required
    - rollback_plan: verified
```

## Best Practices Summary

### Proactive Measures
1. **Regular Scanning**: Automated daily/weekly scans
2. **Update Schedule**: Regular dependency maintenance
3. **Security Training**: Developer security awareness
4. **Threat Modeling**: Understanding attack vectors

### Reactive Measures
1. **Incident Response**: Well-defined process for critical vulnerabilities
2. **Communication Plan**: Stakeholder notification procedures
3. **Lessons Learned**: Post-incident analysis and improvement
4. **Recovery Procedures**: Rollback and recovery capabilities

### Organizational Considerations
1. **Responsibility Assignment**: Clear ownership of security tasks
2. **Resource Allocation**: Adequate security budget and staffing
3. **Tool Selection**: Appropriate security tools for organization size
4. **Compliance Requirements**: Meeting regulatory and industry standards

Remember: Vulnerability management is an ongoing process requiring continuous attention, regular updates to procedures, and organizational commitment to security best practices.